#version 430 core
layout (location = 0) out vec4 screenTexture;

in vec2 TexCoords;

layout (binding = 0) uniform sampler2D image;

uniform vec3 tint;
uniform float transparency;
void main()
{       
	
	vec4 screenTex = texture(image, TexCoords);

	if(tint != vec3(0.0)){
		screenTexture.rgb = tint * length(screenTex.rgb);
	}else{
		screenTexture.rgb = screenTex.rgb;
	}


	float alpha = clamp(screenTex.a * 1.20f * transparency, 0.0, 1.0);

	screenTexture.a = alpha;

}